const BindPlayer = () => {
    const [players, setPlayers] = React.useState([]);
    const [selected, setSelected] = React.useState('');
    const [isLoading, setIsLoading] = React.useState(false);
    const [isPending, setIsPending] = React.useState(false);
    React.useEffect(() => {
        const getPlayers = async () => {
            setIsLoading(true);
            const data = await blessing.fetch.get('/user/player/list');
            const players = data.map((player) => player.name);
            setPlayers(players);
            setSelected(players[0]);
            setIsLoading(false);
        };
        getPlayers();
    }, []);
    const handleSubmit = async (event) => {
        event.preventDefault();
        setIsPending(true);
        const { code, message, } = await blessing.fetch.post('/user/player/bind', { player: selected });
        if (code === 0) {
            await blessing.notify.showModal({ mode: 'alert', text: message });
            window.location.href = `${blessing.base_url}/user`;
        }
        else {
            blessing.notify.showModal({ mode: 'alert', text: message });
        }
        setIsPending(false);
    };
    return isLoading ? (React.createElement("p", null, "Loading...")) : (React.createElement("form", { method: "post", onSubmit: handleSubmit },
        players.length > 0 ? (React.createElement(React.Fragment, null,
            React.createElement("p", null, trans('single-player-limit.bindExistedPlayer')),
            React.createElement("div", { className: "mb-3" }, players.map((player) => (React.createElement("label", { key: player, className: "d-block mb-1" },
                React.createElement("input", { type: "radio", className: "mr-2", checked: selected === player, onChange: () => setSelected(player) }),
                player)))))) : (React.createElement(React.Fragment, null,
            React.createElement("p", null, trans('single-player-limit.bindNewPlayer')),
            React.createElement("input", { type: "text", className: "form-control mb-3", placeholder: trans('general.player.player-name'), onChange: (e) => setSelected(e.target.value) }))),
        React.createElement("button", { className: "btn btn-primary float-right", type: "submit", disabled: isPending }, isPending ? (React.createElement(React.Fragment, null,
            React.createElement("i", { className: "fas fa-spinner fa-spin mr-1" }),
            trans('general.wait'))) : (trans('general.submit')))));
};
ReactDOM.render(React.createElement(BindPlayer, null), document.querySelector('#form'));
