const RegistrationLinksList = () => {
    const [records, setRecords] = React.useState([]);
    const [sharer, setSharer] = React.useState(0);
    const [sharee, setSharee] = React.useState(0);
    React.useEffect(() => {
        const getLinks = async () => {
            const response = await blessing.fetch.get('/user/reg-links');
            setRecords(response.records);
            setSharer(response.sharer);
            setSharee(response.sharee);
        };
        getLinks();
    }, []);
    const handleDeleteClick = async (record) => {
        const { id } = record;
        await blessing.fetch.del(`/user/reg-links/${id}`);
        setRecords((records) => records.filter((record) => record.id !== id));
    };
    const handleGenerateClick = async () => {
        const { data: { record }, } = await blessing.fetch.post('/user/reg-links');
        setRecords((records) => [...records, record]);
    };
    return (React.createElement("div", { className: "card card-primary card-outline" },
        React.createElement("div", { className: "card-header" },
            React.createElement("h3", { className: "card-title" }, "\u5206\u4EAB\u6CE8\u518C\u94FE\u63A5")),
        React.createElement("div", { className: "card-body" },
            React.createElement("p", null,
                "\u5206\u4EAB\u6CE8\u518C\u94FE\u63A5\uFF0C\u5F53\u65B0\u7528\u6237\u4F7F\u7528\u6B64\u94FE\u63A5\u65F6\uFF0C\u60A8\u5C06\u83B7\u5F97 ",
                sharer,
                " \u79EF\u5206\u3002 \u540C\u65F6\u65B0\u7528\u6237\u53EF\u83B7\u5F97 ",
                sharee,
                " \u79EF\u5206\u3002"),
            records.length > 0 ? (React.createElement(React.Fragment, null,
                React.createElement("p", null, "\u53EF\u7528\u7684\u94FE\u63A5\uFF1A"),
                React.createElement("ul", { style: { wordWrap: 'break-word' } }, records.map((record) => (React.createElement("li", { key: record.id },
                    React.createElement("span", { className: "mr-1" }, record.url),
                    React.createElement("a", { href: "#", onClick: () => handleDeleteClick(record) }, "\u5220\u9664"))))))) : ('还没有已生成的链接。')),
        React.createElement("div", { className: "card-footer" },
            React.createElement("button", { className: "btn btn-primary", onClick: handleGenerateClick }, "\u751F\u6210\u65B0\u94FE\u63A5"))));
};
ReactDOM.render(React.createElement(RegistrationLinksList, null), document.querySelector('#registration-links'));
