# 密码算法切换

当您想要对皮肤站的密码加密算法进行切换时，可以使用本插件能让现有用户进行过渡。
如，当皮肤站运行了有一段时间，此时要进行数据对接，不得不要修改算法，就可以配合这个插件，从而不影响现有用户的登录。

虽然本插件允许多种算法同时使用，但请不要将这个作为特性，这个插件仅仅是一种补救措施。

## 使用方法

本插件没有配置页面，所有配置通过修改 `.env` 来进行。

1. 首先将增加一条配置项，名为 `PASSWORD_METHODS`。

2. 以逗号（英文状态下）为分隔符，将需要使用的算法名分别写到 `PASSWORD_METHODS` 项中。注意，新的算法应放在第一位。

3. 修改现有的 `SALT` 变量。同样以逗号分隔，将以上用到的算法所需的盐依次地填写好。如果某个算法不需要盐，直接用一个逗号并写下一个算法的盐就行。

4. 另外请确保已有的变量 `PWD_METHOD` 为您要使用的新算法。

## 示例

假定现在需要切换到 `BCRYPT`，而我们想兼容 `SALTED2MD5` 和 `SHA512` 算法。

我们知道 Bcrypt 和 SHA512 是不需要盐的，而 `SALTED2MD5` 需要。

那么 `.env` 应该像下面这样填写。

```
PASSWORD_METHODS = BCRYPT,SALTED2MD5,SHA512
SALT = ,deadbeef,
```

注意到了吗？虽然只有 `SALTED2MD5` 需要盐，但我们还是需要在 `SALT` 一项中，填写了两个逗号，这与上面的 `PASSWORD_METHODS` 是一一对应的。如果忽略了这些逗号，将导致密码校验失败。

## 最后

当您决定停用本插件时，请适当修改回 `SALT` 变量，使其只有一个盐，并与 `PWD_METHOD` 对应。
